<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.725074376 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A520" />
    <supported-cpuid id="Cortex-A520AE" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA520CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA520INST_RETIRED / $InstructionsPerCycleCortexA520CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA520CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA520STALL_FRONTEND / $FrontendStalledCyclesCortexA520CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA520CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA520STALL_BACKEND / $BackendStalledCyclesCortexA520CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundCortexA520CPU_CYCLES &gt; 0), min((($FrontendBoundCortexA520STALL_SLOT_FRONTEND / (3 * $FrontendBoundCortexA520CPU_CYCLES)) - ($FrontendBoundCortexA520STALL_FRONTEND_FLUSH / $FrontendBoundCortexA520CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA520CPU_CYCLES &gt; 0), min(($BackendBoundCortexA520STALL_SLOT_BACKEND / (3 * $BackendBoundCortexA520CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA520CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA520OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA520STALL_SLOT / ($RetiringCortexA520CPU_CYCLES * 3))) * ($RetiringCortexA520OP_RETIRED / $RetiringCortexA520OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationCortexA520CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationCortexA520OP_SPEC &gt; 0), min((((1 - ($BadSpeculationCortexA520STALL_SLOT / (3 * $BadSpeculationCortexA520CPU_CYCLES))) * (1 - ($BadSpeculationCortexA520OP_RETIRED / $BadSpeculationCortexA520OP_SPEC))) + ($BadSpeculationCortexA520STALL_FRONTEND_FLUSH / $BadSpeculationCortexA520CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA520OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA520OP_RETIRED / $RetiredOperationsPercentageCortexA520OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundCortexA520STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundCortexA520STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundCortexA520STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundCortexA520STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundCortexA520STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundCortexA520STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundCortexA520STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundCortexA520STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundCortexA520STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundCortexA520STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundCortexA520STALL_FRONTEND_FLOW / $FrontendCoreFlowBoundCortexA520STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundCortexA520STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundCortexA520STALL_FRONTEND_L1I + $FrontendMemCacheBoundCortexA520STALL_FRONTEND_MEM) / $FrontendMemCacheBoundCortexA520STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundCortexA520STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundCortexA520STALL_FRONTEND_TLB / $FrontendMemTLBBoundCortexA520STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundCortexA520STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexA520STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundCortexA520STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundCortexA520STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexA520STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundCortexA520STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexA520STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundCortexA520STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundCortexA520STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexA520STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA520INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA520L1I_CACHE_REFILL / $L1ICacheMPKICortexA520INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA520L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA520L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA520L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA520INST_RETIRED &gt; 0), (($ITLBMPKICortexA520ITLB_WALK / $ITLBMPKICortexA520INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA520INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA520L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA520INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA520L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA520ITLB_WALK / $ITLBWalkPercentageCortexA520L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageCortexA520L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageCortexA520ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageCortexA520L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageCortexA520L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageCortexA520ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageCortexA520L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA520L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA520L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA520L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesCortexA520ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesCortexA520ITLB_STEP / $ITLBWalkAverageDepthOfAccessesCortexA520ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyCortexA520ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyCortexA520ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyCortexA520ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundCortexA520STALL_BACKEND &gt; 0), min(($BackendBusyBoundCortexA520STALL_BACKEND_BUSY / $BackendBusyBoundCortexA520STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an in-order core." expression="if(($BackendStallInterlockRateCortexA520STALL_BACKEND &gt; 0), min(($BackendStallInterlockRateCortexA520STALL_BACKEND_ILOCK / $BackendStallInterlockRateCortexA520STALL_BACKEND), 1), 0)" name="Backend Stall Interlock Rate" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundCortexA520STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA520STALL_BACKEND_MEMBOUND / $BackendMemoryBoundCortexA520STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemCacheBoundCortexA520STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemCacheBoundCortexA520STALL_BACKEND_L1D + $BackendMemCacheBoundCortexA520STALL_BACKEND_MEM) / $BackendMemCacheBoundCortexA520STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemTlbBoundCortexA520STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemTlbBoundCortexA520STALL_BACKEND_TLB / $BackendMemTlbBoundCortexA520STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Tlb Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemStoreBoundCortexA520STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemStoreBoundCortexA520STALL_BACKEND_ST / $BackendMemStoreBoundCortexA520STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Mem Cache Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundCortexA520STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexA520STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundCortexA520STALL_BACKEND_L1D / ($BackendCacheL1DBoundCortexA520STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexA520STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundCortexA520STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexA520STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundCortexA520STALL_BACKEND_MEM / ($BackendCacheL2DBoundCortexA520STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexA520STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA520INST_RETIRED &gt; 0), ((($L1DCacheMPKICortexA520L1D_CACHE_REFILL_RD + $L1DCacheMPKICortexA520L1D_CACHE_REFILL_WR) / $L1DCacheMPKICortexA520INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA520L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA520L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA520L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA520INST_RETIRED &gt; 0), ((($L2CacheMPKICortexA520L2D_CACHE_REFILL_RD + $L2CacheMPKICortexA520L2D_CACHE_REFILL_WR) / $L2CacheMPKICortexA520INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA520INST_RETIRED &gt; 0), (($L3CacheMPKICortexA520L3D_CACHE_REFILL_RD / $L3CacheMPKICortexA520INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA520L3D_CACHE_RD &gt; 0), min(($L3CacheMissPercentageCortexA520L3D_CACHE_REFILL_RD / $L3CacheMissPercentageCortexA520L3D_CACHE_RD), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA520INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA520LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA520INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA520LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA520LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA520LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA520LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA520LL_CACHE_RD - $LLCacheReadHitPercentageCortexA520LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA520LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Mem Tlb Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA520INST_RETIRED &gt; 0), (($DTLBMPKICortexA520DTLB_WALK / $DTLBMPKICortexA520INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA520INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA520L1D_TLB_REFILL / $L1DataTLBMPKICortexA520INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA520INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA520L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA520INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Mem Tlb Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA520L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA520DTLB_WALK / $DTLBWalkPercentageCortexA520L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageCortexA520L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageCortexA520DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageCortexA520L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageCortexA520L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageCortexA520DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageCortexA520L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA520L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA520L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA520L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA520L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA520L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA520L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Mem Tlb Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesCortexA520DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesCortexA520DTLB_STEP / $DTLBWalkAverageDepthOfAccessesCortexA520DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Mem Tlb Bound) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyCortexA520DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyCortexA520DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyCortexA520DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA520INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA520BR_IMMED_SPEC + $BranchOperationsPercentageCortexA520BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA520CRYPTO_SPEC / $CryptoOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($IntegerOperationsPercentageCortexA520DP_SPEC / $IntegerOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA520LDST_SPEC / $LoadStoreOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA520VFP_SPEC / $FloatingPointOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA520ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA520INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA520FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA520INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA520INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA520FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA520INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA520INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA520FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA520INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA520LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA520LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA520LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA520LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA520ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA520LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA520LD_SPEC / $LoadOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA520INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA520ST_SPEC / $StoreOperationsPercentageCortexA520INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA520INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA520STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA520INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA520INST_RETIRED &gt; 0), (($BranchMPKICortexA520BR_MIS_PRED_RETIRED / $BranchMPKICortexA520INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Cortex-A520)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA520BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA520BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA520BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA520BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA520BR_IMMED_RETIRED / $BranchDirectPercentageCortexA520BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageCortexA520BR_RETIRED &gt; 0), min(($BranchIndirectPercentageCortexA520BR_IND_RETIRED / $BranchIndirectPercentageCortexA520BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA520BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA520BR_RETURN_RETIRED / $BranchReturnPercentageCortexA520BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_stall_interlock_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_load_store_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A520AE_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_stall_interlock_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A520_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A520_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A520_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A520_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A520_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_load_store_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A520_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A520_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A520_metric_strex_percentage" />
</template>
